from pathlib import Path
import pytest
import shutil
import tempfile
import xtagctl


@pytest.mark.parametrize("i", range(200))
def test_nothing(i):
    """This test is designed to test the keyboard interrupt safety of xtagctl

    Ensure that you have a connected adapter mapped to the "dut" target before executing
    this test.

    To run the test, use:
    ```
    pytest [-n auto] run_parallel.py
    ```
    Then interrupt the test by pressing Ctrl-C
    Running `xtagctl status` should show that no xtags have been left aqcuired
    """
    with xtagctl.acquire("dut"):
        print("Hi")
