//*****************************************//
//  xmidi_globals.h
//
//*****************************************//

#ifndef XMIDI_GLOBALS_H
#define XMIDI_GLOBALS_H


// Structure containing global data
typedef struct GLOBAL_TAG
{
	char port_names[NUM_VALID_PORTS][STR_NAME_LEN]; // Array of names of target ports
	MSG_CONFIG_TYP msg_cfg_arr[NUM_MIDI_MSGS]; // Array of structures of Midi-message configuration data
	char port_num_str[STR_NAME_LEN]; // String containing Ethernet Port Number
	FILE_CONFIG_TYP file_cfg_s; // Structure of file configuration data
	OPTIONS_TYP options_s; // Structure of command-options data
	GENER_TYP gener_s; // Structure of test-vector generation data 
	CHECK_TYP check_s; // Structure of Callback/Midi-check data 

	Socket * sckt_p; // Pointer to Socket object for Ethernet synchronisation between platforms
	SOCKET_ID sckt_id; // Unique socket identifier
	COMMS_CONFIG_ENUM config_id; // Identifies communication configuration
} GLOBAL_TYP;

/*****************************************************************************/
void init_midi_rx_data( // Initialise structure for received midi data
	MIDI_RX_TYP * midi_rx_p // Pointer to structure of received Midi data 
);
/*****************************************************************************/
void init_midi_tx_data( // Initialise structure for transmitted midi data
	MIDI_TX_TYP * midi_tx_p // Pointer to structure of Midi data to transmit 
);
/*****************************************************************************/
FILE_CONFIG_TYP * init_file_config_data( // Initialise file configuration data
	GLOBAL_TYP * glob_p // Pointer to structure of global data
); // Return pointer to structure of file configuration data
/*****************************************************************************/
void init_command_options( // Initialise command-option data
	OPTIONS_TYP * options_p, // Pointer to command-option data structure
	int argc, // Number of command-line arguments
	char * argv[] // Array of command-line arguments pointers
);
/*****************************************************************************/
void init_common_data( // Initialise common data
	GLOBAL_TYP * glob_p // Pointer to structure of global data
); // Return pointer to structure of file configuration data
/*****************************************************************************/
void init_socket( // Initialise socket
	GLOBAL_TYP * glob_p // Pointer to structure of global data
);
/*****************************************************************************/
bool do_all_test_vectors( // Generates all xmidi test vectors
	GLOBAL_TYP * glob_p // Pointer to structure of global data
); // Returns flag indicating if send message was successful
/*****************************************************************************/
U8_T gen_final_test_result( // Generates final 8-bit test result to return to shell
	CHECK_TYP * check_p  // Pointer to structure of Midi check data 
); // Return 8-bit test result
/*****************************************************************************/
#endif /* XMIDI_GLOBALS_H */
