//*****************************************//
//  xmidi_generate.h
//
//  Re-create xmidi_generate using RtMidi
//
//*****************************************//

#ifndef XMIDI_GENERATE_H
#define XMIDI_GENERATE_H

#include <bitset>
#include <iostream>
#include <cstdlib>
#include <typeinfo>
#include <assert.h>
#include "types64bit.h"

// Structure containing data for test vector generation
typedef struct GENER_TAG
{
	U8_T real_time_data[TSTED_RT_MSGS];		// Array of Real-Time message status bytes to test
	U8_T param1_data[NUM_1PARAM_MSGS]; // Array of 'single parameter' channel-message status bytes
	U8_T param2_data[NUM_2PARAM_MSGS]; // Array of 'double parameter' channel-message status bytes

	MIDI_TX_TYP tx_data_s; // Structure of Midi data to transmit
	const MSG_CONFIG_TYP * msg_cfg_arr_p; // Pointer to array of Midi-message configuration data
	FILE_CONFIG_TYP * file_cfg_p; // Pointer to structure of file configuration data
	TST_GEN_TYP tst_gen_s; // Structure of test generation data (re-written for each Midi-message)
	TST_VECT_TYP tst_vect_s; // Structure of test-vector data

	bool print; // Print to screen (if flag set)
} GENER_TYP;

/*****************************************************************************/
void init_generate_data( // Initialise test-vector generation data
	MSG_CONFIG_TYP msg_cfg_arr[], // Array of structures of Midi-message configuration data
	OPTIONS_TYP * options_p, // Pointer to command-option data structure
	GENER_TYP * gener_p // Pointer to structure of test-vector generation data
);
/*****************************************************************************/
bool configure_midi_output_port( // Configure which Midi output port to use
	GENER_TYP * gener_p, // Pointer to structure of test-vector generation data 
	const char port_names[NUM_VALID_PORTS][STR_NAME_LEN] // Array of valid port names
); // Returns true if configuration successful
/*****************************************************************************/
void generate_midi_message( // Generate one Midi-message test
	GENER_TYP * gener_p // Pointer to structure of test-vector generation data 
); // Returns flag indicating if message generation was successful
/*****************************************************************************/

#endif /* XMIDI_GENERATE_H */
