/*
 * Copyright XMOS Limited - 2014
 *
 * Provides functionality for PC's on different IP addresses to communicate 
 * using 'C' based socket endpoint communication.
 * (For more info. See manual page 'socket'. i.e. 'man socket')
 *
 * This lite configuration does NOT have a dependancy on the ErrorHandler object
 */

#ifndef _SOCKET_LITE_H_
#define _SOCKET_LITE_H_


#if defined(__LINUX_ALSA__) || defined(__UNIX_JACK__) || defined(__MACOSX_CORE__)
  #include <unistd.h>
  #include <fcntl.h>
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
  #include <netdb.h>

  #define SOCKLEN socklen_t
  #define SOCKET_ID int
  #define INVALID_SOCKET_ID -1
#elif defined(__WINDOWS_MM__)
  #include <windows.h>
  #include <winsock.h>

  #define SOCKLEN int
  #define SOCKET_ID SOCKET
  #define INVALID_SOCKET_ID INVALID_SOCKET

#else
  /* Error - get compiler to die */
  #include "UnsupportedPlatform"
#endif

class Socket
{
public:
  Socket();
  ~Socket();

  /* Server side. */
  bool socBind(const char *ipAaddress, const char *port); // Returns status flag (0:success)
  void socListen();
  void socAccept();
  int  socReceive(char *buffer, unsigned int bufferLength);

  /* Client side. */
  bool socConnect(const char *ipAddress, const char *port); // Returns status flag (0:success)
  int  socSend(const char *buffer, unsigned int bufferLength);

private:
  /* The copy and assignment constructors are not supported and are not implemented */
  Socket(const Socket &x);
  Socket& operator=(const Socket &x);

private:
  char *getIpAddressFromHostName(const char *ipAddress);

private:
  SOCKET_ID m_socketId;
  bool m_blocking;
  unsigned int m_id;
};

#endif /* _SOCKET_LITE_H_ */
