#! /usr/bin/env python
# Author: J.M.Beaumont
# Date:  05-AUG-2014

import os
import sys
import subprocess
from global_data import GlobalClass


###############################################################################
def write_port_number( comms_data ,port_str ,comm_app_dir ):
    """Writes the input 'socket port number' to a file

    DESCRIPTION: This routine is designed to be called by the (remote) target machine under test.
    Its takes the input 'socket port number' argument,
    and writes it to a file called <glob_data.port_file_name> on the target machine's file-system
    NB If the file already exists, it will be overwritten
    The port number will be accessed by the Midi-transmit or Midi-receive executable,
    running on the (remote) target machine
    """

    glob_data = GlobalClass()  # Initialise global data (See global_data.py)
    
    # This section writes the Port-number to a file on receiving platform.
    # NB This will be read by target-side Midi executables
    
    # Build executable directory path
    comms_inp_dir = comm_app_dir + glob_data.inputs_dir
    
    file_name = comms_inp_dir + glob_data.port_file_name
    out_file = open(file_name ,'w')
    out_file.write( port_str + '\n' )
    out_file.close()
# def write_port_number
###############################################################################
def run_executable( comms_data ,targ_ip_addr ,port_str ):
    """Runs the configured executable on the configured platform, and returns the No. of failures

    DESCRIPTION: An executable (currently either Midi-transmit or Midi-receive)
    is run an a platform (currently one of [Linux Mac Windows7])
    NB Another instance of this function will be running the other executable on another platform,
    to complete the communications link
    """


    glob_data = GlobalClass()  # Initialise global data (See global_data.py)

    scripts_dir = os.path.dirname(os.path.realpath(__file__)) # Get scripts (current) directory

    comm_app_dir = os.path.join( scripts_dir ,'../' ) # common path to application directory

    cmd_args = glob_data.comm_args + targ_ip_addr + ' ' + glob_data.num_tst_str # Preset command arguments

    # Check if need to write socket port to directory on target machine
    if (comms_data.target):
        write_port_number( comms_data ,port_str ,comm_app_dir ) # Write port number to file
        cmd_args = glob_data.targ_arg + cmd_args # Add target-machine argument

    # Build executable directory path
    comms_exe_dir = comm_app_dir + comms_data.exe_dir
    
    # Build results directory path
    comms_results_dir = comm_app_dir + glob_data.results_dir
    
    # Move to application directory, so executable can find input test files
    os.chdir( comm_app_dir )
    
    # Combine executable with arguments
    comms_cmd = comms_data.exe_name + comms_data.exe_ext + cmd_args
    
    # Build 'execute test' system command
    sys_cmd = comms_exe_dir + comms_cmd
    # E.g. sys_cmd = 'H:/git.dir/midi_test.dir/sw_rtmidi/app_xmidi_rtmidi/Win32_Solution/Debug/xmidi_receive.exe -i -x -a10.0.102.125 3'

    return_sts = 255  # Preset to maximum errors. NB Force to unsigned 8-bit type
    
    # Run command and get return status (test result)
    return_sts = subprocess.call( sys_cmd , shell=True )
    
    # Write No. Of Failures to file 
    file_name = comms_results_dir + comms_data.res_name + '.txt'
    out_file = open(file_name ,'w')
    line = '{0:d}\n'.format( return_sts )
    out_file.write( line )
    out_file.close()
    
    if (0 != return_sts):
    		print comms_data.res_name + ' FAILED'
    else:
        print comms_data.res_name + ' PASSED'

    # Return to scripts directory
    os.chdir( scripts_dir )
    
    return return_sts

# def run_executable
###############################################################################
