#! /usr/bin/env python
#
# Description: This script is used when a Mac machine is the host (test master),
#   and is part of Transmit_Platform-->Mac dual-platform Midi-test,
#		and runs the Midi-transmit executable on the Transmit_Platform
#		(NB There is also another script (xxx2plat_rx_tst.py) running the Midi-receive executable on the Receiving_Platform)
# Author: J.M.Beaumont
# Date:  04-AUG-2014

import sys
import socket
from global_data import ConfigClass
from run_executable import run_executable 


port_str = sys.argv[1] # String containing socket port number

# Determine Transmitting platform
if sys.platform.startswith('linux'):
    transmit_platform = 'Linux'  # Configure Receiver for Linux platform
elif sys.platform.startswith('darwin'):
    transmit_platform = 'Mac'  # Configure Receiver for Mac platform
elif sys.platform.startswith('win'):
    transmit_platform = 'Windows7'  # Configure Receiver for Windows7 platform
else:
    print >>sys.stderr, "ERROR. Unsupported Platform: " ,sys.platform
    sys.exit()  # Force exit

cfg_data = ConfigClass( 'Mac' ,transmit_platform ,True )  # Initialise Configuration data for Transmit_Platform-->Mac test (See global_data.py)

domain_name = socket.getfqdn() # get fully qualified domain name
targ_ip_addr = socket.gethostbyname(domain_name) # Get IP address of this platform

run_executable( cfg_data.tx_plat ,targ_ip_addr ,port_str ) # Do Midi-transmit test for Transmit_Platform-->Mac configuration 

sys.exit()  # Force exit
#
