#! /usr/bin/env python
#
# Description: This script is used when a Mac machine is the host (test master),
#   and is part of Mac-->Receive_Platform dual-platform Midi-test,
#		and runs the Midi-receive executable on the Receive_Platform
#		(NB There is also another script (plat2xxx_tx_tst.py) running the Midi-transmit executable on the Tranmit_platform)
# Author: J.M.Beaumont
# Date:  28-JUL-2014

import sys
import socket
from global_data import ConfigClass
from run_executable import run_executable 

port_str = sys.argv[1] # String containing socket port number

# Determine Receiving platform
if sys.platform.startswith('linux'):
    receive_platform = 'Linux'  # Configure Receiver for Linux platform
elif sys.platform.startswith('darwin'):
    receive_platform = 'Mac'  # Configure Receiver for Mac platform
elif sys.platform.startswith('win'):
    receive_platform = 'Windows7'  # Configure Receiver for Windows7 platform
else:
    print >>sys.stderr, "ERROR. Unsupported Platform: " ,sys.platform
    sys.exit()  # Force exit

cfg_data = ConfigClass( 'Mac' ,receive_platform ,False )  # Initialise Configuration data for Mac-->Receive_Platform  test (See global_data.py)

domain_name = socket.getfqdn() # get fully qualified domain name
targ_ip_addr = socket.gethostbyname(domain_name) # Get IP address of this platform

run_executable( cfg_data.rx_plat ,targ_ip_addr ,port_str ) # Do Midi-receive test for Mac-->Receiving_Platform configuration 

sys.exit()  # Force exit
#
