#! /usr/bin/env python
#
# Description: This script controls the 'killing off' of old hanging xmidi jobs and test scripts
# Author: J.M.Beaumont
# Date:  04-AUG-2014

import subprocess
import sys


file_name = 'tmp.txt' # Temporary filename
out_file = open(file_name ,'w') # open file for writing

# Write all matching xmidi processes to temporary file ...

sys_cmd = 'ps aux | egrep "xmidi|tst" | grep dir | grep -v grep'
return_sts = subprocess.call( sys_cmd ,stdout=out_file ,shell=True )
if (0 != return_sts):
		print >>sys.stderr, "FAILED to do 'ps aux' tests" ,return_sts
		sys.exit()  # Force exit

out_file.close() # close file after writing

inp_file = open(file_name ,'r') # re-open temporary file for reading

# loop through all lines in file
for line in inp_file:
    word_list = line.split()  # Split line into words on whitespace
    job_num = word_list[1]  # get process number

    sys_cmd = 'kill -9 ' + job_num  # build 'kill-job' command

    return_sts = subprocess.call( sys_cmd ,shell=True )  # execute kill-job command
    if (0 != return_sts):
    		print >>sys.stderr, "FAILED to do 'ps aux' tests" ,return_sts
    		sys.exit()  # Force exit

sys.exit()  # Force exit
#
