#! /usr/bin/env python
#
# Description: Class Object to hold global data
# Author: J.M.Beaumont
# Date:  29-JUL-2014

import operator 
import socket

# This list allows scripts to differentiate between test-rig and development platforms

full_name = socket.gethostname() # get full platform name. e.g. wishfish.xmos.local
word_list = full_name.split('.')
local_plat = word_list[0] # e.g. wishfish
# print 'Local Platform= ' ,local_plat

class PlatformClass(object):  # Used a structure for Platform specific data
    def __init__(self ,plat_name ,comms_mode='UnDef' ,tx_host='UnDef' ):
        self.platform = plat_name
        self.mode = comms_mode  # Communications mode (i.e. Tx/Rx)

        if ('Linux' == plat_name):
            self.tla = 'lnx' # Three Letter Acronym
            self.lsh_cmd = ''    # NO local command shell required for Linux
            self.exe_dir = 'midi_Linux.dir/bin.dir/'  # Linux executable sub-directory of comm_app_dir 
            self.exe_ext = '.x'    # extension for Linux executable
            self.ssh_cmd = 'sshpass -p xmos0115 ssh '  # secure shell command required for Linux
        elif ('Mac' == plat_name):
            self.tla = 'mac' # Three Letter Acronym
            self.lsh_cmd = ''    # NO local command shell required for Mac
            self.exe_dir = 'midi_Darwin.dir/bin.dir/'  # Mac executable sub-directory of comm_app_dir 
            self.exe_ext = '.x'    # extension for Linux executable
            self.ssh_cmd = 'sshpass -p xmos0115 ssh '  # secure shell command required for Mac
        elif ('Windows7' == plat_name):
            self.tla = 'win' # Three Letter Acronym
            self.lsh_cmd = 'cmd /C '    # local command shell required for Windows7
            self.exe_dir = 'midi_Win32_Solution/Debug/' # Windows executable sub-directory of comm_app_dir NB Backslashes will be substitued later
            self.exe_ext = '.exe'  # extension for Linux executable
            self.ssh_cmd = 'ssh '  # secure shell command required for Windows
        else:
            print >>sys.stderr, "ERROR. Unrecognised Platform: " ,plat_name
            sys.exit()  # Force exit

        if ('Rx' == comms_mode):
            self.exe_name = 'xmidi_receive'
            self.target = tx_host # NB target=True if this Platform is target machine under test
        elif ('Tx' == comms_mode):
            self.exe_name = 'xmidi_transmit'
            self.target = (not tx_host) # NB target=True if this Platform is target machine under test
        elif ('UnDef' == comms_mode):
            self.exe_name = 'UnDefined'
            self.target = 'UnDefined'
        else:
            print >>sys.stderr, "ERROR. Unrecognised Communications mode: " ,comms_mode
            sys.exit()  # Force exit

    def display(self ): # for debug
        print
        print 'platform=' ,self.platform
        print 'target=' ,self.target
        print 'mode=' ,self.mode
        print 'tla=' ,self.tla
        print 'lsh_cmd=' ,self.lsh_cmd
        print 'exe_dir=' ,self.exe_dir
        print 'exe_ext=' ,self.exe_ext
        print 'ssh_cmd=' ,self.ssh_cmd
        print 'exe_name=' ,self.exe_name
        print
            
# end class PlatformClass(object)

class ConfigClass(object):  # Configuration data
    def __init__(self ,host_plat_str ,targ_plat_str ,tx_host ):  # NB tx_host=True if Transmitter on host machine
        # WARNING: For sockets to work, the IP address of the Midi-receive Platform,
        # must be set equal to the IP address of the Midi-transmit Platform
        # In addition, the audio test-rig only works when
        # the socket IP address is set to the IP address of the target-machine (i.e. NOT the host-machine)
        if (tx_host):
            self.tx_plat = PlatformClass( host_plat_str ,'Tx' ,tx_host )  # Initialse data for Transmitter Platform
            self.rx_plat = PlatformClass( targ_plat_str ,'Rx' ,tx_host )  # Initialse data for Receiver Platform
        else:
            self.tx_plat = PlatformClass( targ_plat_str ,'Tx' ,tx_host )  # Initialse data for Transmitter Platform
            self.rx_plat = PlatformClass( host_plat_str ,'Rx' ,tx_host )  # Initialse data for Receiver Platform

        # Build filenames from Configuration data ...

        # Build result-file names
        self.res_base_name = self.tx_plat.tla + '2' + self.rx_plat.tla
        self.res_log_name = self.tx_plat.platform + '-to-' + self.rx_plat.platform

        self.rx_plat.res_name = self.res_base_name + '_rx'
        self.tx_plat.res_name = self.res_base_name + '_tx'

        # Build script-file names
        self.rx_plat.script_name = self.tx_plat.tla + '2plat_rx_tst.py'
        self.tx_plat.script_name = 'plat2' + self.rx_plat.tla + '_tx_tst.py'
# end class PlatformClass(object)

class GlobalClass(object):
    def __init__(self):
        self.num_tst_str = ' 2048' # Number of xmidi tests to run
        self.targ_arg = ' -t' # argument used if on target machine (NOT host-machine)
        self.comm_args = ' -i -s2 -a' # common arguments
        self.port_file_name = 'port_number.txt' # Name of file holding 'socket-port-number'
        self.scripts_dir = 'midi_scripts.dir/'  # python scripts sub-directory of comm_app_dir 
        self.results_dir = 'midi_results.dir/'  # results sub-directory of comm_app_dir 
        self.inputs_dir = 'midi_inputs.dir/'  # input files sub-directory of comm_app_dir 

        # Determine path to common midi directory
        import os

        cur_dir = os.path.dirname(os.path.realpath(__file__)) # Get scripts (current) directory path
        (cur_dir ,scripts_dir) = os.path.split(cur_dir)  # Split-off scripts directory
        (cur_dir ,midi_dir) = os.path.split(cur_dir)  # Split-off midi directory
        (cur_dir ,repo_dir) = os.path.split(cur_dir)  # Split-off repository directory

        self.midi_dir = os.path.join( repo_dir ,midi_dir + '/') # Rebuild sub-directory path to midi-directory
# end GlobalClass(object)
