import subprocess
import platform

from hardware_test_tools.XcoreApp import XcoreApp


class AudioAnalyzerHarness(XcoreApp):
    def __init__(self, adapter_id, sw_dir, board="xcore200_mc", config=None, attach=None):
        self.sw_dir = sw_dir

        xe_name = (
            f"app_audio_analyzer_{board}_{config}.xe"
            if config
            else f"app_audio_analyzer_{board}.xe"
        )
        bin_dir = self.sw_dir / f"app_audio_analyzer_{board}" / "bin"
        if config:
            bin_dir = bin_dir / f"{config}"

        super().__init__(bin_dir / xe_name, adapter_id, attach=attach)

    def xscope_controller_cmd(self, cmds, timeout=30, cmd_timeout=0):
        assert self.attach == "xscope_app"
        assert platform.system() in ["Darwin", "Windows"]

        base_dir = self.sw_dir / "host_xscope_controller"

        if platform.system() == "Windows":
            xscope_controller = base_dir / "bin_windows" / "xscope_controller.exe"
        elif platform.system() == "Darwin":
            xscope_controller = base_dir / "bin_macos" / "xscope_controller"

        assert xscope_controller.exists(), f"xscope_controller not present at {xscope_controller}"

        ret = subprocess.run(
            [xscope_controller, "localhost", f"{self.xscope_port}", f"{cmd_timeout}", *cmds],
            capture_output=True,
            text=True,
            timeout=timeout,
        )
        assert ret.returncode == 0, (
            f"xscope controller command failed on port {self.xscope_port} with commands {cmds}"
            + f"\nstdout:\n{ret.stdout}"
            + f"\nstderr:\n{ret.stderr}"
        )

        return ret.stdout, ret.stderr
