// Copyright (c) 2016-2017, XMOS Ltd, All rights reserved
#include <platform.h>

#define TILE_1_BOOT_CHANEND 0x00010002
#define CRC_DISABLE_MAGIC 0x0D15AB1E

void boot_tile1(chanend c, int tile0_num_words, int tile1_num_words)
{
  unsigned w;
  int i;

  // do nothing on tile 1
  // (symbol for calling this function is placed in both tiles' images)
  unsafe {
    if (XS1_CHAN_ID_PROCESSOR((int)c) != 0)
      return;
  }

  asm("setd res[%0], %1" :: "r"(c), "r"(TILE_1_BOOT_CHANEND));
  unsafe {
    outuint(c, (int)c);
  }

  outuint(c, tile1_num_words);
  for (i = tile0_num_words; i < tile0_num_words + tile1_num_words; i++) {
    // can't cast integer to pointer due to bug 17507
    asm("ldw %0, %1[%2]" : "=r"(w) : "r"(XS1_RAM_BASE), "r"(i));
    outuint(c, w);
  }
  outuint(c, CRC_DISABLE_MAGIC);
  outct(c, XS1_CT_END);
}
