// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <xs1.h>
#include <chan.h>

unsafe unsafe streaming chanend chan_getr(void)
{
  unsafe chanend c;
  asm("getr %0, 2" : "=r"(c));
  return c;
}

void chan_freer(unsafe streaming chanend c)
{
  asm("freer res[%0]" :: "r"(c));
}

void chan_setd(unsafe streaming chanend c, int dest_id)
{
  asm("setd res[%0], %1" :: "r"(c), "r"(dest_id));
}
