// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>
#include <stdio.h>
#include "trycatch.h"

#define LINK_NUM    4
#define INTER_DELAY 2
#define INTRA_DELAY 3
#define W   0   //for 5w internal links

void link_disable(int link_num)
{
  // disable link by resetting ENABLE bit in link's control register
  unsigned x;
  read_sswitch_reg(get_local_tile_id(), XS1_SSWITCH_XLINK_0_NUM + link_num, x);
  x &= ~XS1_XLINK_ENABLE_MASK;
  write_sswitch_reg(get_local_tile_id(), XS1_SSWITCH_XLINK_0_NUM + link_num, x);
}

void link_enable(int link_num)
{
  unsigned x;
  read_sswitch_reg(get_local_tile_id(), XS1_SSWITCH_XLINK_0_NUM + link_num, x);
  // configure link by writing to link's control register:
  // set intertoken and intratoken delays
  // set ENABLE bit
  // set WIDE bit if 5-bit link required
  x |= XS1_L_XLINK_INTER_TOKEN_DELAY_SET(x, INTER_DELAY);
  x |= XS1_L_XLINK_INTRA_TOKEN_DELAY_SET(x, INTRA_DELAY);
  x |= XS1_XLINK_ENABLE_MASK;
  x |= W * XS1_XLINK_WIDE_MASK;
  write_sswitch_reg(get_local_tile_id(), XS1_SSWITCH_XLINK_0_NUM + link_num, x);
}

void t1(streaming chanend c)
{
  exception_t exception;
  for (int i=0; i<4; i++) {
    link_disable(i);
    delay_milliseconds(50);
  }
  delay_milliseconds(100);

  link_enable(5);
  delay_milliseconds(50);
  link_enable(6);
  delay_milliseconds(50);
  link_enable(7);
  delay_milliseconds(50);
  link_enable(8);
  delay_milliseconds(50);

  TRY {
  while (1) {
    c <: 'a'; //12345;
  } CATCH (exception) {
    printf("Got exception:\n");
  }
  }
}

void t2(streaming chanend c)
{
  int i = 0, j;
  char k;
  timer bw_tmr;
  int bw_t;
  exception_t exception;

  for (int i=0; i<4; i++) {
    link_disable(i);
    delay_milliseconds(50);
  }
  delay_milliseconds(100);

  link_enable(5);
  delay_milliseconds(50);
  link_enable(6);
  delay_milliseconds(50);
  link_enable(7);
  delay_milliseconds(50);
  link_enable(8);
  delay_milliseconds(50);

  bw_tmr :> bw_t;
  TRY {
  while (1) {
    select {
      //case c :> j:
      case c :> k:
        i++;
        break;
      case bw_tmr when timerafter(bw_t + 100000000) :> void:
        printf("communication rate: %d bytes per sec ==> %d Mbit/sec\n", i, ((i*8)/1000000));
        i = 0;
        bw_tmr :> bw_t;
        break;
    }
  } CATCH (exception) {
     printf("Got exception:\n");
  }
/*    c :> j;
    i++;

    if (i == 1000) {printf("j-"); i = 0; }*/
  }

}

int main(void)
{
  streaming chan c;
  par {
      on tile[0] : t1(c);
      on tile[1] : t2(c);
  }
  return 0;
}
