// Copyright (c) 2015, XMOS Ltd, All rights reserved
#ifndef _BIQUAD_H_
#define _BIQUAD_H_
#include <stdint.h>

typedef struct biquad_state_t biquad_state_t;

int32_t apply_biquad(int32_t val, biquad_state_t &st);

enum biquad_type_t {
  BIQUAD_LOPASS = 0,
  BIQUAD_HIPASS,
  BIQUAD_BANDPASS,
  BIQUAD_NOTCH,
  BIQUAD_ALLPASS,

  NUM_BIQUAD_TYPES
};

#define BIQUAD_PARAM_FRACTIONAL_BITS 28

// Q parameter for Butterworth filters i.e. 0.7071 as a 4.28 fixed point number
#define BIQUAD_Q_BUTTERWORTH 189810711

void init_biquad_state(enum biquad_type_t type,
                       unsigned significant_freq,
                       unsigned sample_freq,
                       uint32_t Q,
                       biquad_state_t &st);


/** Structure for holding the state of the biquad filter. This structure
    should be initialized with init_biquad_state(). */
struct biquad_state_t {
  int32_t b[3];
  int32_t a[2];
  int32_t prev_inputs[2];
  int32_t prev_outputs[2];
  int64_t error;
};



#endif /* _BIQUAD_H_ */
