// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to display the resources used by a program
----------------------------------------------

You can use the xTIMEcomposer tools to show the resources used by a
given executable. For example, compile the following code:
**/

#include <print.h>

int main() {
  printstr("Hello World!\n");
  return 0;
}

/**
Double-click on the resulting binary from within the *Project
Explorer*. This will load the binary into both the resource and the
tmiing analysis tools, and switch to the most recently used analysis
perspective. Click the *Analyze Binary* button in the toolbar. A
number of options are now available:

   * A graphical view of the resources used by the program (in the
     *Resources* tab).

   * The sizes/locations of functions and global data objects (in the
     *Function Table* and *Data Table* tabs).

   * The I/O pins top ports mappings for the choosen target package.

   * The callgraph.

You can view the resources used by the resulting executable from the
command line using *xobjdump*:

   xobjdump --resources a.xe

This will produce the following output:

   ....
   tile[0] (node "0", tile 0) stack usage,  upper bound: 208
   tile[0] (node "0", tile 0) program size,  upper bound: 1092
   tile[0] (node "0", tile 0) free memory,  lower bound: 64236
   tile[0] (node "0", tile 0) thread usage,  upper bound: 1
   tile[0] (node "0", tile 0) unused threads,  lower bound: 7
   tile[0] (node "0", tile 0) timer count,  upper bound: 0
   tile[0] (node "0", tile 0) unused timers,  lower bound: 10
   tile[0] (node "0", tile 0) channel end usage,  upper bound: 0
   tile[0] (node "0", tile 0) unused channel ends,  lower bound: 32
   Node "0" routing id =  0x0000
   Node "0" PLL configuration register value =  0x00002700
   Node "0" reference clock divider register value =  0x00000003
   Node "0" system frequency (Hz) =  400000000

You can also display the code and data section sizes as follows:

   xobjdump --size a.xe

This will produce the following output:

   Loadable 1 for tile[0] (node "0", tile 0):

         text      data       bss     total
          680        84        64       828
**/

