// Copyright (c) 2016, XMOS Ltd, All rights reserved

#include <print.h>

interface TestInterface {
  void func1(int param);
};

void clientTask(client interface TestInterface iface) {
  iface.func1(5); 
}

void serverTask(server interface TestInterface iface){
  unsigned int complete = 0;
  while (!complete) {
    select {
      case iface.func1(int param):
        printintln(param);
        complete = 1;
        break;
    }
  }
}

int main() {
  interface TestInterface iface;
  par {
    clientTask(iface);
    serverTask(iface);
  }
  return 0;
}

