// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to pass arguments to the target application
-----------------------------------------------

The xTIMEcomposer tools support the passing of arguments to the target
application via *argc/argv* parameters in *main*.

You must first specify the maximum size of the buffer to use to
contain the command line arguments in target memory. This is specified
using the *-fcmdline-buffer-bytes* compiler switch. As seen in the
*Makefile*, in this case we have set it to 128 bytes.

Now compile the following code snippet:
**/


#include <stdio.h>

int main(int argc, char *argv[]) {
    printf("argc = %d\n", argc);
    for (unsigned int i = 0; i < argc; ++i) {
        printf("argv[%d] = %s\n", i, argv[i]);
    }
    return 0;
}

/**
This code simply displays both the total number of command line
arguments passed, and each of thier values.

The resulting executable can then be run from the command line:

   > xrun --io --args bin/AN10127_xtimecomposer_target_argument_support.xe a b

This will produce the following output:

   argc = 3
   argv[0] = bin/AN10127_xtimecomposer_target_argument_support.xe
   argv[1] = a
   argv[2] = b

Likewise, arguments can be passed to the target if calling xgdb
directly:

   > xgdb --args a.xe bin/AN10127_xtimecomposer_target_argument_support.xe a b

Finally, if running on the simulator, the mechanism is the same:

   > xsim --args a.xe bin/AN10127_xtimecomposer_target_argument_support.xe a b

If you are developing from within the xTIMEcomposer studio, arguments
can be specified using the *Arguments* tab in the run/debug
configurations.
**/

