// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to generate XTA command scripts
-----------------------------------

Typically, the XTA is used interactively to investigate and measure
the timing properties of a program. Once satisfied, it is often a
requirement to capture the current state of the tool in order to
automate this process in the future. To help with this, the XTA can
generate a script which will reproduce any global defines and the
current set of routes, including their requirements and any local
defines.

For example, compile the following code:
**/


#include <stdlib.h>
#include <xs1.h>

port p1 = XS1_PORT_1A;
port p2 = XS1_PORT_1B;

int main() {
  int x;

  #pragma xta endpoint "input"
  p1 :> x;

  // Checks for errors..
  if (x == 1) {
    #pragma xta label "error_case"
    exit(1);
  }

  // do some computation here..

  #pragma xta endpoint "output"
  p2 <: 0;
  return 0;
}

/**
In the GUI, load the resulting executable into the tool and time
between the input and output endpoints. Set the exclusion on the error
case and set a timing requirement of 100.0 ns. Next, click the
*Generate script* button on the toolbar. In the dialog, input a script
file name, e.g. *script.xta*. Clicking *OK* will cause a script to be
generated, which by default will be located at the top level of your
project. In future, recompiling your project will now cause this
script to be run.
**/

