// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to use the XTA to time between 2 I/O instructions
-----------------------------------------------------

The XTA can be used to time the code between 2 I/O instructions.
Compile the following code and load it into the XTA.

In the xTIMEcomposer studio, select the *Analyze* button on the left-
hand side navigation toolbar. Next select the *Analyse Timing*
perspective via the main toolbar. A binary can be loaded into the XTA
then via the *Load Binary into XTA* toolbar button.
**/


#include <xs1.h>

port p = XS1_PORT_1A;


int main() {
  int x;

  /** In the editor, right-click on the endpoint marker in the border of the
      following line and select 'set from endpoint'
   **/
  #pragma xta endpoint "endpoint1"
  p :> x; // endpoint 1

  // Some computation here...

  /** In the editor, right-click on the endpoint marker in the border of the
      following line and select 'set to endpoint'
   **/
  #pragma xta endpoint "endpoint2"
  p :> x; // endpoint 2

  /** Click the 'Analyse Between Endpoints' button in the main toolbar. The
      best and worst case timing for this path will then be displayed in the
      Routes view in the left hand panel.
   **/

  return 0;
}

/**
To load a binary, then time between endpoints using the command line
XTA, or from XTA scripts/embedded source commands, the following
commands can be used:

   load a.xe
   analyze endpoints endpoint1 endpoint2

Note: In order to do this is a maintainable way, the above relies on
the *xta endpoint* pragma, which lets you associate a label with an
endpoint (I/O instruction) in the source code.
**/

