// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to set a timing requirement in the XTA
------------------------------------------

Compile some code, for example:
**/


int f() {
  return 0;
}

int main() {
  return f();
}

/**
First, load the executable into the XTA, then time the function 'f'.
This will create a route as shown in the Routes view in the left hand
panel. The top pane of the Routes view allows a route to be selected,
whereas the bottom pane displays the timing for the current selection.

Right-click on the route and select 'Set timing requirement' Once
supplied, the pass/fail status of the route will be displayed in this
routes icon.

To set a timing requirement using the command line XTA, or from an XTA
script/embedded source command, the following can be used:

   set required 0 10.0 us

This will set a timing requirement of 10 microseconds on the route
with an id of 0.
**/

