// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to use the XTA to time a function
-------------------------------------

The XTA can be used to determine the worst and best case timing for a
function. Compile the following code:
**/


int add1(int x) {
  return x + 1;
}

int main() {
  add1(10);
  return 0;
}

/**
Load the resulting binary into the XTA.

In the xTIMEcomposer studio, select the *Analyze* button on the left-
hand side navigation toolbar. Next select the *Analyse Timing*
perspective via the main toolbar. A binary can be loaded into the XTA
then via the *Load Binary into XTA* toolbar button.

From the command line, a binary can be loaded using the following xta
command:

   load a.xe

The *add1* function can then be timed as follows:

In the xTIMEcomposer studio, use the 'Select function to analyze'
dropdown button in the toolbar to select the 'add1' function. The best
and worst case timing for this function will then be displayed in the
*Routes* view in the left hand panel.

To time a function using the command line XTA, or from an XTA
script/embedded source command, the following can be used:

   analyze function add1
**/


