// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to use xobjdump to inspect and manipulate XE files
------------------------------------------------------

The xTIMEcomposer tools contain the *xobjdump* utility, which you can
use to inspect, and potentially update, the contents of XE files. For
example, compile the following multicore program using the
*SLICEKIT-L16* target:
**/

#include <platform.h>

int f() {
  return 0;
}

int main() {
  par {
    on tile[0]: f();
    on tile[1]: f();
  }
  return 0;
}

/**
An XE file is an XMOS specific container format for a number of
resources that go toward making up an xCORE multicore binary. Most
importantly, it contains one or more ELF files per tile. To see the
contents of the resulting executable, use *xobjdump* with the
*--sector-info* command line switch:

   > xobjdump --sector-info a.xe
   a.xe: file format: xcore-xe

   Xmos binary sector information: file: a.xe

   0: NODEDESC sector, part number: 0x2633
   1: NODEDESC sector, part number: 0x2633
   2: ELF sector for tile[0] (node "0", tile 0)
   3: CALL sector. Address: 0x00000000
   4: ELF sector for tile[1] (node "1", tile 0)
   5: CALL sector. Address: 0x00000000
   6: ELF sector for tile[0] (node "0", tile 0)
   7: GOTO sector. Address: 0x00000000
   8: ELF sector for tile[1] (node "1", tile 0)
   9: GOTO sector. Address: 0x00000000
   10: SYSCONFIG sector
   11: XN sector
   12: PROGINFO sector
   13: LASTSEC sector

If you need access to the these contained files, they can be dumped to
the file system using the *--split* command line switch. You can then
use standard ELF utilities such as *readelf* to inspect the contents
of the tile specific ELF files.

You can also add and replace sectors in the XE file using *xobjdump*.
See *xobjump --help* for further details.
**/

