// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to disassemble a program using xobjdump
-------------------------------------------

The xTIMEcomposer tools contain the *xobjdump* utility, which you can
use to disassemble a given executable. For example, compile the
following code:
**/

#include <print.h>

int main() {
  printstr("Hello World!\n");
  return 0;
}

/**
From the command line, the resulting executable can be disassembled as
follows:

   xobjdump -d a.xe

This will produce the following output:

   ....
   <main>:
                0x000100ac: 44 77:       entsp (u6)      0x4
                0x000100ae: 4e 68:       ldc (ru6)       r1, 0xe
                0x000100b0: 00 f0 05 60: ldaw (lru6)     r0, dp[0x5]
                0x000100b4: 00 f0 4d d0: bl (lu10)       0x4d <printstr>
                0x000100b8: 40 68:       ldc (ru6)       r1, 0x0
                0x000100ba: 42 54:       stw (ru6)       r1, sp[0x2]
                0x000100bc: 01 54:       stw (ru6)       r0, sp[0x1]
                0x000100be: 02 5c:       ldw (ru6)       r0, sp[0x2]
                0x000100c0: c4 77:       retsp (u6)      0x4
   ....

You can use xobjdump to intermix the source lines with the disassembly
output. This is enabled via the -S command line option:

   xobjdump -S a.xe

This will produce the following output:

   ....
   int main() {
                0x000100ac: 44 77:       entsp (u6)      0x4
                0x000100ae: 4e 68:       ldc (ru6)       r1, 0xe
     printstr("Hello World!\n");
                0x000100b0: 00 f0 05 60: ldaw (lru6)     r0, dp[0x5]
                0x000100b4: 00 f0 4d d0: bl (lu10)       0x4d <printstr>
                0x000100b8: 40 68:       ldc (ru6)       r1, 0x0
     return 0;
                0x000100ba: 42 54:       stw (ru6)       r1, sp[0x2]
                0x000100bc: 01 54:       stw (ru6)       r0, sp[0x1]
                0x000100be: 02 5c:       ldw (ru6)       r0, sp[0x2]
                0x000100c0: c4 77:       retsp (u6)      0x4
   ....
**/

