// Copyright (c) 2016, XMOS Ltd, All rights reserved

/**
How to enable ASCII tracing when running on the simulator
---------------------------------------------------------

The simulator optionally provides a textual instruction trace.

For example, compile the following code:
**/

#include <xs1.h>

port p = XS1_PORT_1A;
int main() {
  int x;
  p :> x;
  return 0;
}

/**
When enabled, the input from the port 'p' into variable 'x' will
produce the corresponding line in the trace file:

   tile[0]@0- -A-.----000100cc (main +  8) : in r0(0x0), res[r0(0x10200)] @2127

See the xTIMEcomposer User Guide
(http://www.xmos.com/doc/XM-000930-PC/latest#xsim-manual-tracing-
table) for further information on the trace format.

The ASCII simulator trace can be enabled via:

*Run -> Run Configurations -> Simulator -> Trace to console*

This will send the trace directly to the console view as the
application is running.

Note: If required, the trace can be redirected to a file via:

*Run -> Run Configurations -> Simulator -> Trace to file*

Alternatively, on completion we can automatically switch to the
simulator tracing perspective and load the trace file using:

*Run -> Run Configurations -> Simulator -> Open in trace view*

The ASCII simulator trace can be enabled via the *-t* xsim command
line option:

   xsim -t a.xe

If tracing of fetch no-ops (FNOPS) is required, it can be enabled via
the *--enable-fnop-tracing* xsim command line option:

   xsim -t --enable-fnop-tracing a.xe

This will insert the lines of the following format into the trace at
the relevant locations:

   tile[0]@0 FNOP @2655
**/

