// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to run an executable on the XMOS simulator
----------------------------------------------

Compile the following code:
**/

#include <print.h>

int main() {
  printstr("Hello World!\n");
  return 0;
}

/**
From within xTIMEcomposer Studio, select *Run -> Run Configurations*,
and double click on the *xCORE Application* option. This will create a
new Run configuration. In the *Device options* group, check the
*simulator* box.

Alternatively, to run from the command line:

   xsim a.xe

This will execute the given program (a.xe) until completion, in this
case displaying 'Hello World! in the console.

From within xTIMEcomposer Studio, select *Run -> Debug
Configurations*, and double click on the *xCORE Application* option.
This will create a new Debug configuration. In the *Device options*
group, check the *simulator* box.

Alternatively, to debug from the command line:

   xgdb a.xe

This will start the XMOS debugger. To tell the debugger to connect to
the simulator use:

   connect -s

Loading the program onto the target (xgdb command: *load*), and
continuing (xgdb command: *continue*) will cause the program to run to
completion and display 'Hello World!' on the console.
**/

