// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to enable the gathering of statistics using the simulator
-------------------------------------------------------------

The xTIMEcomposer simulator can optionally output statistics on the
current simulation run. This includes the number of core cycles taken,
the proportion of these that was spent idle and the number of fetch
no-ops. It also provides information on the number of times each
instruction was executed.

For example, compile the following minimal code snippet:
**/


int main() {
  return 0;
}

/**
From within xTIMEcomposer Studio, enable collection of simulation
statistics using:

*Run -> Run Configurations -> Simulator -> Display Statistics*

This will send the statistics output directly to the console view, in
this case:

   SimulationStats:
   ----------------
   FnopCount : 66
   InactiveProcessorCycles : 1595
   SimulationCycles : 2283
   ...etc...

If running on the command line, statistics output can be enabled using
the *--stats* xsim command line option:

   xsim --stats a.xe
**/

