// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to display the pin, port and link mappings for a particular target
----------------------------------------------------------------------

The xTIMEcomposer simulator can optionally output the pin, port and
link mappings for the target that the given binary was compiled for.

For example, compile the following minimal code snippet for a
particular target, e.g. *STARTKIT*:
**/


int main() {
  return 0;
}

/**
Run the following from the command line:

   xsim --dump-ios a.xe

The resulting output is split into three sections. The first section
of the output contains the port->pin mappings. The second section
contains the xlink->pin mappings. The final section contains the
pin->port mappings.

Note: The equivalent information is available in the binary analysis
perspective of xTIMEcomposer Studio. Double-click on the required XE
file in the *Project Explorer* view. This will automatically to the
analysis perspectives that was most recently open. Click the *Analyze
Binary* perspective button in the toolbar, then select the *I/O Map*
tab.
**/

