// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to enable VCD tracing when running on the simulator
-------------------------------------------------------

The xTIMEcomposer simulator can optionally generate a VCD (value
change dump) trace file which describes external and/or internal
simulation state. This file can then be viewed in the VCD viewer built
in to xTIMEcomposer Studio, or in an 3rd party VCD viewer such as
GTKWave. This mechanism is typically used to visualize the transitions
on the ports/pins, although you can also use it to examine internal
machine state such as the instructions/functions executed and the
state of other machine resources such as channels or clockblocks.

As an example, compile the following code:
**/

#include <xs1.h>

port p = XS1_PORT_1A;
int main() {
  p <: 1;
  p <: 0;
  return 0;
}

/**
From within xTIMEcomposer Studio, the VCD tracing can be enabled
using:

*Run -> Run Configurations -> Simulator -> Signal Tracing -> Enable
signal tracing*

Check this box, then click the *ADD* button situated within the *Trace
Tile Options* group. Check the *ports* box. When the run terminates, a
.vcd file is produced and added at the top level of the relevent
project directory, the VCD tracing perspective is opened and the VCD
file is loaded. Double-click on XS1_PORT_1A in the signals view to
import the associated signals into the *Waves* view. Click the *zoom
fit* button located in the *Waves* view toolbar to examine the
activity on the port.

From the command line, VCD tracing can be enabled using the following:

   xsim --vcd-tracing '-o trace.vcd -ports' a.xe

The above will produce a *trace.vcd* file, which can then be opened in
a VCD viewer.
**/

