// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to connect ports via loopback using the XMOS simulator
----------------------------------------------------------

The xTIMEcomposer simulator contains a plugin mechanism that lets you
model external components via plugins. As part of the xTIMEcomposer
tools, a pre-built loopback plugin is provided which enables
ports/pins to be connected, thus allowing testbenches to be written in
xC.

For example, compile the following code for the XK-1A target:
**/

#include <xs1.h>
#include <print.h>
#include <platform.h>

port p1 = XS1_PORT_1A;
port p2 = XS1_PORT_1B;

int main() { 

  par {
    {
       p1 <: 1;
    }
    {
       p2 when pinseq(1) :> void;
       printstrln("Done!\n");
    }
  }
  return 0;
}

/**
The intention is to connect the pins of port *p1* to the pins of port
*p2*, thus allowing the example to complete successfully. Note: If you
run the above code without making the connection, the execution will
pause indefinitely, due to the fact that *p2* will never go high.

There are a number of ways to specify the ports/pins to connect using
the loopback plugin.

From within xTIMEcomposer Studio, select the *Simulator* tab of the
Run configuration and the *Loopback* tab in the *Plugins* group. Add a
new connection from PORT_SPI_MISO to PORT_SPI_SS.

To run from the command line:

   xsim --plugin LoopbackPort.dll "-port PORT_SPI_MISO 1 0 -port PORT_SPI_SS 1 0" a.xe

From within xTIMEcomposer Studio, select the *Simulator* tab of the
Run configuration and the *Loopback* tab in the *Plugins* group. Add a
new connection from tile[0], XS1_PORT_1A (offset 0, width 1) to
tile[0], XS1_PORT_1B (offset 0, width 1).

To run from the command line:

   xsim --plugin LoopbackPort.dll "-port tile[0] XS1_PORT_1A 1 0 -port tile[0] XS1_PORT_1B 1 0" a.xe

To run from the command line:

   xsim --plugin LoopbackPort.dll "-pin 0 X0D00 -pin 0 X0D01" a.xe
**/

