// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to profile an executable on hardware
----------------------------------------

The xTIMEcomposer tools provide support for generating a GNU profiler
(gprof) compatible output file. This file contains the instruction
timing information, also known as the flat profile. As an example,
compile the following code, ensuring that the generation of debug info
(-g) is enabled:
**/

#include <math.h>

int main() {
  int i;
  float x = 0;
  for (i = 0; i < 100000; ++i) {
     x += sin(x);
  }
  return 0;
}

/**
Create a new run configuration for the chosen target. To enable
profiling output, select the Run configuration and check the *Enable
GPROF collection* box on the *Main* tab. On execution, a number of
.gprof files (one per core) will be created at the top level of the
project.

On completion, the xTIMEcomposer studio will automatically switch to
the profiling perspective, and prompt for both the required
>>*<<.gprof file and it's corresponding binary. Once selected, the
profile information will be displayed, which allows the timing of the
program to be analyzed on a source line-by-line basis.

Run the executable on hardware, use the *--gprof* command line switch:

   xrun --gprof a.xe

This will produce a number of .gprof files, one per core. The *xgprof*
tool, supplied in the xTIMEcomposer suite, can be used to analyze the
profile from the command line. *xgprof* accepts as input both the
generated profile (.gprof) file and the relevant ELF file. The ELF
files can be extracted from the XE file as follows:

   xobjdump --split a.xe

*xgprof* can then be run from the command line in the following way:

   xgprof image_n0c0.elf tile[0]_core0.gprof

The above will generate report for the code running on core 0.
**/

