// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to write to a file during execution
---------------------------------------

The xTIMEcomposer tools can handle system calls on behalf of the
target application. This handling is enabled by default.
**/


#include <print.h>
#include <stdio.h>
#include <stdlib.h>
#include <syscall.h>

int main() {

  /** A file can be opened for writing as follows:
   **/
  int fd = _open("test.txt", O_WRONLY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if (fd == -1) {
    printstrln("Error: _open failed");
    exit(1);
  }

  /** An open file can be written using the *_write* system call
   **/
  if (_write(fd, "hello there!", 13) != 13) {
    printstrln("Error: _write failed");
    exit(1);
  }
 
  /** We can then close an open file using the *_close* system call
   **/
  if (_close(fd) != 0) {
    printstrln("Error: _close failed.");
    exit(1);
  }
  return 0;
}

/**
Compile the above code. When the resulting executable is run, a file
called test.txt containing 'hello world!' is written to the current
working directory.

Note: In this case we are using the raw system call functions
directory as we are working in XC. However, if working in C then it
might be advisable to the the C std library equivalents: *fopen*,
*fwrite* and *fclose*.
**/

