// Copyright (c) 2015, XMOS Ltd, All rights reserved

/**
How to perform a general system call during execution
-----------------------------------------------------

The xTIMEcomposer tools can handle system calls on behalf of the
target application. This handling is enabled by default.

For example, compile the following code snippet:
**/


#include <syscall.h>

int main() {
  _system("echo hello");
  return 0;
}

/**
When the resulting executable is run, XSIM will pass the string 'echo
hello' to the operating system for execution on the host:

   > xsim a.xe
   hello

This is also supported on hardware and can be executed as follows:

   > xrun --io a.xe
   hello
**/

