// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>
#include <stdio.h>
#include <print.h>
#include <overlay_quadflash.h>

//Defines that represent button state
#define NOBUTTON 15
#define BUTTON1 14
#define BUTTON2 13

//LED port on explorerKIT 
on tile[0] : out port g_led_ports = XS1_PORT_4F;

//Button port on explorerKIT
on tile[0] : in buffered port:4 g_button_port = XS1_PORT_4E;

//QuadSPI Ports on explorerKIT
on tile[0] : static fl_QSPIPorts g_qspi_ports = {
  PORT_SQI_CS,
  PORT_SQI_SCLK,
  PORT_SQI_SIO,
  XS1_CLKBLK_1
};

//A movable pointer to the QuadSPI ports.
static fl_QSPIPorts * movable g_qspi_ports_ptr = &g_qspi_ports;

//Function in an overlay region
[[overlay]]
void ledBlue(out port led_ports)
{
  char blue   = 2;
  led_ports <: blue;
}

//Function in an overlay region
[[overlay]]
void ledGreen(out port led_ports)
{
  char green = 4;
  led_ports <: green;
}

//Function in an overlay region
[[overlay]]
void ledRed(out port led_ports)
{
  char red   = 8;
  led_ports <: red;
}

//Function that will initialize overlays for use and then load the correct
//function depending on the status of the buttons
void chooseOverlayRegion()
{
  overlay_quadflash_init(move(g_qspi_ports_ptr), 100, 8);
  int current = 0;
  while (1) 
  {
    select {
    case g_button_port when pinsneq(current) :> current:
      break;
    default:
      if (current == NOBUTTON)
        ledBlue(g_led_ports);
      else if (current == BUTTON1)
        ledGreen(g_led_ports);
      else if (current == BUTTON2)
        ledRed(g_led_ports);
      break;
    }
  }//while
}

int main(void)
{
  par
  {
    on tile[0]:
    {
      chooseOverlayRegion();
    }

    on tile[1]:
    {
      while(1);
    }
  }

  return 0;
}
