// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>

/**
How to use the xSCOPE start/stop event type
-------------------------------------------

xSCOPE is fully supported on hardware platforms which provide an XMOS
link between the target device and the XSYS development connector, it
is also supported via xSIM.

View the document (http://www.xmos.com/doc/XM-000957-PC/latest/page31
#trace-data-with-xscope) for further information on tracing data from
XMOS applications.

This example provides a simple demonstration of using the xSCOPE
start/stop event type for data logging from within an xCORE
application. The start/stop event type is used for recording the time
taken for between two points in an application. This allows a user to
see how long the device has spent in specific code sections for
performance analysis and debugging

The probe configuration is handled by the user providing a
config.xscope file which is picked up as part of the application
build.

This example assumes you are familiar with creating a run
configuration and enabling the associated xSCOPE options in that run
configuration in xTIMEcomposer Studio or using the command line tools.
**/


/**
    In order to used xSCOPE the correct header file must be included in
    the application
**/

#include <xscope.h>

void wait(int delay)
{
  timer t;
  int i;
  t :> i;
  t when timerafter(i + delay) :> i;
}

/**
Within a function make a call to xscope_start() / xscope_stop() for a
specified probe to signal a toggle in state from start to stop. This
allows the time period between these points to be measured.
**/

void function_1(void)
{
  xscope_start(FUNCTION_1);
  wait(150000);
  xscope_stop(FUNCTION_1);
}


void function_2(void)
{
  xscope_start(FUNCTION_2);
  wait(500000);
  xscope_stop(FUNCTION_2);
}

void function_3(void)
{
  xscope_start(FUNCTION_3);
  wait(50000);
  xscope_stop(FUNCTION_3);
}

void function_4(void)
{
  xscope_start(FUNCTION_4);
  wait(240000);
  xscope_stop(FUNCTION_4);
}


int main(void)
{
  par {
    on tile[0]: {
      for (int i = 1; i < 10; i++) {
        function_1();
        function_2();
        function_3();
        function_4();
      }
    }
  }

  return 0;
}
