// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to use realtime xSCOPE on the XMOS simulator
------------------------------------------------

Compile the following code:
**/

#include <stdlib.h>
#include <xscope.h>
int main() {
    while (1) {
        xscope_int(VALUE, rand() * 100);
    }
    return 0;
}

/**
Note: The probe used in the above example is defined in the
config.xscope file.

Select *Run -> Run Configurations*, and double click on the *xCORE
Application* option. This will create a new Run configuration. In the
*Device options* group, check the *simulator* box. Realtime xSCOPE can
be enabled via the checkbox in the xSCOPE tab. Running this example
will open the *Real-Time Scope* view and display the corresponding
values.

   xsim bin/Debug/realtime_Debug.xe --xscope '-realtime
   localhost:12345'

Run the above. To visualise the output open the xTIMEcomposer studio
and select *Tools->XRTScope*. In the *Real-Time Scope* view, click the
*Connect* button in the view toolbar. Select the IP address/port pair
that matches the above command line, check the *is simulation* box,
then click *Connect*.
**/

