// Copyright (c) 2016, XMOS Ltd, All rights reserved
/**
How to use offline xSCOPE on the XMOS simulator
-----------------------------------------------

Compile the following code:
**/

#include <xscope.h>
int main() {
    for (int i = 0; i < 100; ++i) {
        xscope_int(VALUE1, i);
        xscope_int(VALUE2, i * 2);
        xscope_int(VALUE3, i * 3);
    }
    return 0;
}

/**
Note: The 3 probes used in the above example are defined in the
config.xscope file.

Select *Run -> Run Configurations*, and double click on the *xCORE
Application* option. This will create a new Run configuration. In the
*Device options* group, check the *simulator* box. Offline xSCOPE can
be enabled via the checkbox in the xSCOPE tab. Running this example
will produce a file named *xscope.xmt* located at the top level of the
project. Double clicking on this file will open it in the *Offline
Scope* view.

   xsim a.xe --xscope '-offline xscope.xmt'

Running the above will produce a file named *xscope.xmt* in the
current directory. To view the contents of the file, open the
xTIMEcomposer studio and select *Tools->XScope*. In the *Offline
Scope* view, use the *Load* button in the view toolbar.
**/

