// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to use xSCOPE I/O on the XMOS simulator
-------------------------------------------

Compile the following code:
**/

#include <print.h>
int main() {
    printstr("Hello World\n");
    return 0;
}

/**
Note: xSCOPE is enabled and the *ioMode* is set to *basic* in the
config.xscope file.

Select *Run -> Run Configurations*, and double click on the *xCORE
Application* option. This will create a new Run configuration. In the
*Device options* group, check the *simulator* box. xSCOPE I/O can be
enabled by checking the *Offline* box in the xSCOPE tab. Running this
example will then display the output in the console view.

   xsim a.xe --xscope '-offline xscope.xmt'

It is worth noting however, that the handling of system calls by the
XMOS simulator is instantaneous from the point of view of the target.
Therefore, using xSCOPE for I/O redirection will make the target run
slower, thus is of limited use in reality.
**/

