// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>
#include <stdio.h>

/**
How to redirect printing functions with timing via xSCOPE
---------------------------------------------------------

xSCOPE is fully supported on hardware platforms which provide an XMOS
link between the target device and the XSYS development connector, it
is also supported using xSIM.

View the document (http://www.xmos.com/doc/XM-000957-PC/latest/page31
#trace-data-with-xscope) for further information on tracing data from
XMOS applications.

This example provides a demonstration of redirecting the standard
printing routines available in the xTIMEcomposer tools via the xSCOPE
trace system. Redirecting printing over xSCOPE provides a streaming
print capability that does not stop the xCORE device when a print
message is issued. The allows printing to be done from applications
which have real time constraints providing a valuable debugging tool
for the developer.

In this case the standard printf() call is redirected via xSCOPE.

The redirection is handled by the user providing a config.xscope file
which is picked up as part of the application build. In this example
timed print redirection is specfied which sends print messages via
xSCOPE and displays a timestamp for each print message sent along with
the message data.

This example assumes you are familiar with creating a run
configuration and enabling the associated xSCOPE options in that run
configuration in xTIMEcomposer Studio or using the command line tools.
**/


int main (void) {
  par {
    on tile[0]: {
      for (int i = 0; i < 10; i++) {
        printf("value of i is %d\n", i);
      }
    }
  }
  return 0;
}

