// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>
#include <math.h>

/**
How to use xSCOPE to capture floating point data
------------------------------------------------

xSCOPE is fully supported on hardware platforms which provide an XMOS
link between the target device and the XSYS development connector, it
is also supported using xSIM.

View the document (http://www.xmos.com/doc/XM-000957-PC/latest#trace-
data-with-xscope) for further information on tracing data from XMOS
applications.

This example provides a simple demonstration of using the xSCOPE
continuous event type for data logging from within an xCORE
application. The continuous event type is used for recording the value
of a variables within an application. The data type captured by the
xSCOPE probe can be specified by the user and in this case we look at
capturing a floating point value.

The probe configuration is handled by the user providing a
config.xscope file which is picked up as part of the application
build.

This example assumes you are familiar with creating a run
configuration and enabling the associated xSCOPE options in that run
configuration in the xTIMEcomposer Studio or using the command line
tools.
**/


/**
    In order to used xSCOPE the correct header file must be included in
    the application
**/

#include <xscope.h>

int main(void)
{
  par {
  on tile[0]: {
  float i = 0;
  float value = 0;

  for (i = 0; i < 40; i += 0.01) {
    value = sin(i);
    /** The xscope_float() function is used to send the contents of user
        variable value to the specified XSCOPE probe. The floating point type
        is recorded for correct display when the data is processed on the host
        machine. In this example data is sent to the registered probes SIN_1 -
        SIN_9.
     **/
    xscope_float(SIN_1, value * 100);
    value = sin(i);
    xscope_float(SIN_2, value * 90);
    value = sin(i);
    xscope_float(SIN_3, value * 80);
    value = sin(i);
    xscope_float(SIN_4, value * 70);
    value = sin(i);
    xscope_float(SIN_5, value * 60);
    value = sin(i);
    xscope_float(SIN_6, value * 50);
    value = sin(i);
    xscope_float(SIN_7, value * 40);
    value = sin(i);
    xscope_float(SIN_8, value * 30);
    value = sin(i);
    xscope_float(SIN_9, value * 20);
    value = sin(i);
    xscope_float(SIN_10, value * 10);
  }
  }
  }

  return 0;
}
