// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <platform.h>

/**
How to use the xSCOPE continuous event type
-------------------------------------------

xSCOPE is fully supported on hardware platforms which provide an XMOS
link between the target device and the XSYS development connector, it
is also supported using xSIM.

View the document (http://www.xmos.com/doc/XM-000957-PC/latest#trace-
data-with-xscope) for further information on tracing data from XMOS
applications.

This example provides a simple demonstration of using the xSCOPE
continuous event type for data logging from within an XMOS
application. The continuous event type can be used to capture and log
the value of specific variables within an application to allow
debugging.

The probe configuration is handled by the user providing a
config.xscope file which is picked up as part of the application
build.

This example assumes you are familiar with creating a run
configuration and enabling the associated xSCOPE options in that run
configuration in xTIMEcomposer Studio or using the command line tools.
**/


/**
    In order to used xSCOPE the correct header file must be included in
    the application
**/

#include <xscope.h>
 
/**
    The xscope_int() function is used to send the contents of user
    variable data_value_1 to xSCOPE probe CONTINUOUS_VALUE_1 for logging
**/

void output_data_1(unsigned int data_value_1) {
  xscope_int(CONTINUOUS_VALUE_1, data_value_1);
}

/**
    The xscope_int() function is used to send the contents of user
    variable data_value_2 to xscope probe CONTINUOUS_VALUE_2 for logging
**/

void output_data_2(unsigned int data_value_2) {
  xscope_int(CONTINUOUS_VALUE_2, data_value_2);
}


int main (void) {
  par {
    on tile[0]: {
      int i = 0;

      for (i = 0; i < 100; i++) {
	 output_data_1(i*i);
	 output_data_2(i*i*2);
      }

    }
  }
  return 0;
}
