// Copyright (c) 2015, XMOS Ltd, All rights reserved
#include <print.h>
#include <xs1.h>

int main() {
  timer t;
  unsigned int start_time, end_time;
/**
  How to wait for a period of time using a timer
  ----------------------------------------------
  
  Timers can be used to pause a task until a certain amount of time has
  passed. First input the current time from the timer:
**/

  t :> start_time;
/**
  Next compute the time you want the task to wait until, by adding the
  desired number of timer ticks to the start time:
**/

  end_time = start_time + 123;
/**
  Finally use the following statement to wait for end_time to be
  reached:
**/

  t when timerafter(end_time) :> void;
  return 0;
}
