// Copyright (c) 2015, XMOS Ltd, All rights reserved
int main() {
/**
  How to read the time from a timer
  ---------------------------------
  
  A timer is a xCORE resource with a 32-bit counter that is continually
  incremented at a rate of 100MHz. You can declare a timer as follows:
**/

  timer t;

/**
  Timers may be declared as local variables inside a function or as
  global variables. An input statement can be used to read the value of
  a timer's counter (i.e. read the current time). This is done via the
  operator ':>' used to specify an input:
**/

  unsigned int time;

  t :> time;

/**
  This will input the current time from the timer 't' to the variable
  'time'.
**/


  return 0;
}
