// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to use the select statement
-------------------------------

A select statement waits for one of a set of inputs to become ready,
performs the selected input and then executes a corresponding body of
code. Each input is proceeded by the keyword case and its body must be
terminated with a break or return statement. Case statements are not
permitted to contain output operations.
**/


#include <platform.h>
#include <print.h>


void RX (chanend chnlend_a, chanend chnlend_b)
{
  unsigned chnl_input_a = 0;
  unsigned chnl_input_b = 0;

  while (1)
  {
/**
    In this example the select statement is used to wait for either an
    input on chnlend_a or an input on chnlend_b.  When an input is
    received from either channel the value of the input is printed.
**/

    select
    {
      case chnlend_a :>  chnl_input_a :
        printstr("Channel Input A Received ");
        printintln(chnl_input_a);
        break;
      case chnlend_b :> chnl_input_b :
        printstr("Channel Input B Received ");
        printintln(chnl_input_b);
        break;
    }

  }
}

void TX (chanend chnlend_a, chanend chnlend_b)
{
  unsigned chnl_output = 0;

  while (1)
  {
    chnl_output++;

    //if the value of chnl_output is divisible by 5 then output it to chnlend_a
    if (chnl_output % 5 == 0)
    {
      chnlend_a <: chnl_output;
    }

    //if the value of chnl_output is divisible by 10 then output it to chnlend_b
    if (chnl_output % 10 == 0)
    {
      chnlend_b <: chnl_output;
    }
  }
}

int main(void)
{
  chan chnl_a, chnl_b;

  par
  {
    on stdcore[0] : RX(chnl_a, chnl_b);
    on stdcore[1] : TX(chnl_a, chnl_b);
  }

  return 0;
}

