// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to set a watchpoint
-----------------------

Data watchpoints are used to allow XGDB to halt the execution of a the
program when a condition placed on a data object by the user evaluates
to true. For example, compile the following code ensuring that debug
is enabled (-g):
**/

#include <print.h>

int main() {
  int i, j = 0;
  for (i = 0; i < 5; ++i) {
    printintln(i);
  }
  return 0;
}

/**
Create a new debug configuration via *Run->debug Configurations->xCORE
Applications*. Set a breakpoint at the start of *main* then start
debugging. Execution will now break when *main* is reached. In the
variables view, right-click on the entry for the loop count *i* and
choose *Add Watchpoint (C/C++)*. In the dialog enter *i == 3*, then
continue execution. The debugger will now break when the value of the
loop index variable *i* evaluates to 3. This can be confirmed by
hovering over the variable in the editor.

On the command line, watchpoints are set using the *watch* command.
For example, start XGDB, connect to the simulator and set a breakpoint
on main. When run, execution will break at the start of main.  You can
now set a watchpoint on the variable *i*:

   > xgdb a.xe
   ...etc...
   (gdb) connect -s
   0xffffc04e in ?? ()
   (gdb) b main
   Breakpoint 1 at 0x100b0: file setting_a_watchpoint.xc, line 12.
   (gdb) run
   ...etc...
   Breakpoint 1, main () at setting_a_watchpoint.xc:12
   12    int i, j = 0;
   (gdb) watch i == 3
   Hardware watchpoint 2: i == 3
   (gdb) continue
   0
   1
   2
   Hardware watchpoint 2: i == 3

   Old value = 0
   New value = 1
   0x000100c4 in main () at setting_a_watchpoint.xc:13
   13    for (i = 0; i < 5; ++i) {
   (gdb) print i
   $1 = 3
**/


