// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to set a conditional breakpoint
-----------------------------------

Instruction breakpoints are used to allow XGDB to halt the execution
of a program at a user defined position in the code. Furthermore, if a
condition is set on a breakpoint then it will only be taken when the
breakpoint location is reached and the condition evaluates to true.
For example, compile the following code ensuring that debug is enabled
(-g):
**/

int f(int i) {
  return 0;
}

int main() {
  f(1);
  f(2);
  f(3);
  return 0;
}

/**
Create a new debug configuration via *Run->debug Configurations->xCORE
Applications*.  Double-click in the left-hand margin of the *return 0*
line in function *f*. This will create a new instruction breakpoint.
Right-click on the breakpoint and select *Breakpoint properties*.
Select the *Common* entry on the list on the left-hand pane.  A
condition can then be entered in the *Condition* text box. In this
case, setting the condition *i == 3* will cause the breakpoint to be
hit on the 3rd call the function *f*.

Breakpoints are set using the *breakpoint* command. This command
returns an ID which can be used to refer to the breakpoint. A
condition can be set on a breakpoint using the *condition* command,
which takes as arguments a breakpoint ID and the condition itself. The
following is an example of an XGDB session using a condition
breakpoint:

   > xgdb a.xe
   ...etc..
   (gdb) connect -s
   0xffffc04e in ?? ()
   (gdb) breakpoint f
   Breakpoint 1 at 0x100b4: file setting_a_conditional_breakpoint.xc, line 12.
   (gdb) condition 1 (i == 3)
   (gdb) run
   ...etc...
   Breakpoint 1, f (i=3) at setting_a_conditional_breakpoint.xc:12
   12    return 0;
   (gdb) print i
   $1 = 3
   (gdb)
**/


