// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to set a breakpoint
-----------------------

Instruction breakpoints are used to allow XGDB to halt the execution
of a the program at a user defined position in the code. For example,
compile the following code ensuring that debug is enabled (-g):
**/

int f() {
  return 0;
}

int main() {
  f();
  return 0;
}

/**
Create a new debug configuration via *Run->debug Configurations->xCORE
Applications*. Double click in the left-hand margin of the *return 0*
line in function *f*. This will create a new instruction breakpoint,
thus when run, execution will pause when this line is reached.

Breakpoints are set using the *breakpoint* command. This takes the
breakpoint location as an argument, which can be either a function
name or a file/linenumber combination.  For example, the XGDB command:
*breakpoint setting_a_breakpoint.xc:2* will install a breakpoint on
the first line of the function *f* in the above code.

Using the above code, an example XGDB session using breakpoints could
be as follows:

   > xgdb a.xe
   ...etc...
   (gdb) connect -s
   0xffffc04e in ?? ()
   (gdb) breakpoint f
   Breakpoint 1 at 0x100ac
   (gdb) run
   ...etc...
   Breakpoint 1, 0x000100ac in f ()
   (gdb) c
**/


