// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to automate the repetition of XGDB commands
-----------------------------------------------

Sometimes it is useful to be able to repeat a sequence of XGDB
commands a number of times. For example, in order to better understand
the reason why a program traps, it might be instructive to 'single
step' your way to the trap instead of just continuing. This might give
us an indication of the route taken leading up to the trap. As a
simple example of using this mechanism, compile the following code
ensuring that debug is enabled (-g):
**/

int main() {
  int i, j = 0;
  for (i = 0; i < 5; ++i) {
    j += i;
  }
  return 0;
}

/**
For example, start XGDB, connect to the simulator, set a breakpoint on
*main* and start debugging. Execution will now break when *main* is
reached. The following example tells XGDB to single step while i < 5,
and on each step, print the value of the loop index i:

   > xgdb a.xe
   ...etc...
   (gdb) connect -s
   0xffffc070 in ?? ()
   (gdb) b main
   Breakpoint 1 at 0x100b0: file repeating_commands_interactively.xc, line 13.
   (gdb) run
   ...etc...
   Breakpoint 1, main () at repeating_commands_interactively.xc:13
   13    int i, j = 0;
   (gdb) while i < 5
    >step
    >print i
    >end
   14    for (i = 0; i < 5; ++i) {
   $1 = -1159860211
   15      j += i;
   $2 = 0
   14    for (i = 0; i < 5; ++i) {
   $3 = 0
   15      j += i;
   $4 = 1
   14    for (i = 0; i < 5; ++i) {
   $5 = 1
   15      j += i;
   $6 = 2
   14    for (i = 0; i < 5; ++i) {
   $7 = 2
   15      j += i;
   $8 = 3
   14    for (i = 0; i < 5; ++i) {
   $9 = 3
   15      j += i;
   $10 = 4
   14    for (i = 0; i < 5; ++i) {
   $11 = 4
   17    return 0;
   $12 = 5
   (gdb)
**/


