// Copyright (c) 2016, XMOS Ltd, All rights reserved
#include <stdio.h>
/**
How to use references
---------------------
**/


void pass_by_reference_example();

int main() {

  /** References provide a method of indirectly referrering to some data.
      For example, the following declarations create a reference 'x' to the
      integer 'i':
   **/

  int i = 5;
  int &x = i;

  /** Reading and writing a reference is the same as reading and writing to
      the original variable:
   **/

  printf("The value of x is %d\n", x);
  x = 7;
  printf("x has been updated to %d\n", x);
  printf("i has also been updated to %d\n", i);

  /** References can also refer to array elements:
   **/

  int a[5] = {1,2,3,4,5};
  int &y = a[0];

  printf("y has value %d\n", y);


  pass_by_reference_example();

  return 0;
}

/**
    Function parameters can also be references. For example, the following
    function takes a reference and updates the value it refers to:
**/


void f(int &x) {
  x = x + 1;
}

/**
    This function can be called with the value to refer to as an argument:
**/


void pass_by_reference_example() {
  int i = 5;
  printf("Value of i is %d\n", i);
  f(i);
  printf("Value of i is %d\n", i);
}




