// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to perform timed output on a port
-------------------------------------

An output operation can be performed on a port at a specific time with
respect to its clock.
**/


#include <xs1.h>

out port toggle_port = XS1_PORT_1A;

int main() {

  int count;

/**
   The following statement performs a timestamped output, outputting the
   value 0 to the port 'toggle_port' and reading into the variable
   'count' the value of the port counter when the output data is driven
   on the pins.
**/

  toggle_port <: 0 @ count;
  while(1) {
  /** The statements
   **/
  count += 3;
  toggle_port @ count <: 1;
/**
   cause the port to wait until its counter equals the value count+3 and
   then drive its pin high.  The next two statements delay the driving of
   the pin low by 2 clock periods.
**/

  count += 2;
  toggle_port @ count <: 0;
  }

  return 0;
}

/**
The ability to control output on a port can also be achieved using a
timer resource from the processor.  Note however that the ports time
operator is 16-bit whereas the processor timer resource is 32-bit. See
example "How to control port output data rates with timers" for
further information.
**/

