// Copyright (c) 2015, XMOS Ltd, All rights reserved
/**
How to select on a port
-----------------------
**/

#include <xs1.h>

port p = XS1_PORT_1A;

int main() {
  /** Port activity can cause events which a task can react to via a
      'select' statement.
      
      For example, the following select waits until the value on the pins of
      port 'p' is equal to 1 and then reacts to that event, inputting on
      that port into the variable 'x'.
   **/
  select {
  case p when pinseq(0x1) :> int x:
    // handle the event here
    break;
  }

  /* Note that without external activity on the pins (for example in the
     simulator) this example will just wait forever. */
  return 0;
}
